/*
 SAMrI SUMO 344:1 Gear-ratio version

 Modified October 12 2020 by Craig Maynard

This example code is in the public domain.

This code controls the SAMrI robot

Note:  Each motor ( Left motor and Right motor ) have two inputs which behave as follows

LMOT_A    LMOT_B       EN_LMOT   | Action
_______________________________________________
   LOW        LOW        PWM     | Motor Coast Brake
   LOW        HIGH       PWM     | Motor Direction 1  
   HIGH       LOW        PWM     | Motor Direction 2
   HIGH       HIGH       PWM     | Motor Hard Brake

RMOT_A    RMOT_B       EN_RMOT   | Action
_______________________________________________
   LOW        LOW        PWM     | Motor Coast Brake
   LOW        HIGH       PWM     | Motor Direction 1  
   HIGH       LOW        PWM     | Motor Direction 2
   HIGH       HIGH       PWM     | Motor Hard Brake


Inputs LINE_R and LINE_L from the reflective photoeyes return 
a number approaching 255 when bright, and approaching 0 when left.
   
*/

// Here are the SAMrI specific definitions

#include "Arduino.h"
#define LMOT_A 21     //
#define LMOT_B 12     //
#define RMOT_A 20     //
#define RMOT_B 13     //   These definitions tie "user defined" names to Arduino IO pins
#define EN_RMOT 10    //
#define EN_LMOT 9     //
#define LINE_R 15     //
#define LINE_L 14     //


// Here are the general purpose IO definitions:

#define PB0 8     //
#define PB1 9     //
#define PB2 10     //
#define PB3 11     //
#define PB4 12     //
#define PB5 13     //
#define PB6 20     //
#define PB7 21     //
#define PC0 14     //
#define A0 14      //
#define PC1 15     //
#define PC2 16     //    
#define PC3 17     //   These definitions tie the Ardiuino pins to the ATMEL PORT numbers
#define PC4 18     //
#define PC5 19     //
#define PC6 22     //
#define PD0 0      //
#define PD1 1      //
#define PD2 2      //
#define PD3 3      //
#define PD4 4      //
#define PD5 5      //
#define PD6 6      //
#define PD7 7      //

int PWM_LEFT = 250;       //
int PWM_RIGHT = 250;      //
int Lefteye = 50;         //Lefteye threshold
int Righteye = 50;        //Righteye threshold
int Speedlimit = 150;     //    
int forwardflag = 0;      //Helps avoid calling routines unecessarily


//-------------------------INITIALIZATION STARTS--------------------------------------------------
void setup() {
  // Setup serial connection IF you have a serial FTDI interface
   Serial.begin(9600);
   Serial.println("Sumo Ready!");

  Lefteye == analogRead(LINE_L)+100;   //Set threshold to be 100 more than the current sensed value
  Righteye == analogRead(LINE_R)+100;  //Set threshold to be 100 more than the current sensed value
  
  pinMode(RMOT_A, OUTPUT);     //
  pinMode(RMOT_B, OUTPUT);     //
  pinMode(LMOT_A, OUTPUT);     //
  pinMode(LMOT_B, OUTPUT);     //  These assignments make the IO pins an INPUT pin or and OUTPUT pin
  pinMode(EN_RMOT, OUTPUT);    //
  pinMode(EN_LMOT, OUTPUT);    //
  pinMode(LINE_R, INPUT);      //
  pinMode(LINE_L, INPUT);      //

  Serial.println ("0.5 seconds to go!");
  delay (500);                // wait for 0.5 seconds before starting
  Serial.println ("GO!!");

}

//-------------------------END INITIALIZATION--------------------------------------------------


//-------------------------MAIN LOOP STARTS----------------------------------------------------

void loop(){


while ( (analogRead(LINE_R) > Righteye) && (analogRead(LINE_L) > Lefteye)){     //  Black=High number, White=Low number
  
if (forwardflag == 0){                    // forwardflag stops entering bearright, if its already doing that.
  bearright();                            // ... go forward!  ( Call bearright routine )
}
  
}

if( (analogRead(LINE_R) < Righteye)){       //  IF the Lefteye sees Dark...
  brake();                                  // ... Stop...
  reverse();                                //     Then Reverse...
  delay (1000);                             // ... for 1000mS
  leftspin();                               //     Then Leftspin...
  delay (1500);                             // ... for 500mS
  forwardflag=0;
}

if( (analogRead(LINE_L) < Lefteye)){        //  IF the Lefteye sees Dark..
  brake();                            // ... Stop..
  reverse();                            //     Then Reverse..
  delay (1000);                         // ... for 1000mS
  rightspin();                          //     Then Leftspin...
  delay (1500);                          // ... for 500mS
  forwardflag=0;
  
}


} //End of loop


// ----------------------------END OF MAIN LOOP-------------------------------------------------------

// ----------------------------BEGINNING OF SUBROUTINES-------------------------------------------------------

void forward(){

  analogWrite(EN_RMOT, Speedlimit);
  digitalWrite(RMOT_A, HIGH); 
  digitalWrite(RMOT_B, LOW);
  analogWrite(EN_LMOT, Speedlimit);
  digitalWrite(LMOT_A, HIGH); 
  digitalWrite(LMOT_B, LOW);
  forwardflag=1;
}

void bearright(){

  analogWrite(EN_RMOT, 75);
  digitalWrite(RMOT_A, HIGH); 
  digitalWrite(RMOT_B, LOW);
    analogWrite(EN_LMOT, Speedlimit);
  digitalWrite(LMOT_A, HIGH); 
  digitalWrite(LMOT_B, LOW);
  forwardflag=1;
  
}
void bearleft(){

  analogWrite(EN_RMOT, Speedlimit);
  digitalWrite(RMOT_A, HIGH); 
  digitalWrite(RMOT_B, LOW);
    analogWrite(EN_LMOT, 75);
  digitalWrite(LMOT_A, HIGH); 
  digitalWrite(LMOT_B, LOW);
  forwardflag=1;
  
}

void reverse(){

  Serial.println( "BACKWARD " );
 
  analogWrite(EN_RMOT, 50);
  digitalWrite(RMOT_A, LOW); 
  digitalWrite(RMOT_B, HIGH);
  analogWrite(EN_LMOT, 50);
  digitalWrite(LMOT_A, LOW); 
  digitalWrite(LMOT_B, HIGH); 
  delay (300);

  analogWrite(EN_RMOT, 100);
  digitalWrite(RMOT_A, LOW); 
  digitalWrite(RMOT_B, HIGH);
  analogWrite(EN_LMOT, 100);
  digitalWrite(LMOT_A, LOW); 
  digitalWrite(LMOT_B, HIGH); 
  delay (300);

  analogWrite(EN_RMOT, Speedlimit);
  digitalWrite(RMOT_A, LOW); 
  digitalWrite(RMOT_B, HIGH); 

  analogWrite(EN_LMOT, Speedlimit);
  digitalWrite(LMOT_A, LOW); 
  digitalWrite(LMOT_B, HIGH); 
}

void brake(){

  Serial.println( "STOP " );
  digitalWrite(EN_RMOT, HIGH);
  digitalWrite(RMOT_A, HIGH); 
  digitalWrite(RMOT_B, HIGH); 

  digitalWrite(EN_LMOT, HIGH);
  digitalWrite(LMOT_A, HIGH); 
  digitalWrite(LMOT_B, HIGH); 
}

void rightspin(){

  PWM_RIGHT=100;
  PWM_LEFT=100;
  Serial.println( "RIGHTSPIN " );
  analogWrite(EN_RMOT, PWM_RIGHT);
  digitalWrite(RMOT_A, HIGH); 
  digitalWrite(RMOT_B, LOW); 

  analogWrite(EN_LMOT, PWM_RIGHT);
  digitalWrite(LMOT_A, LOW); 
  digitalWrite(LMOT_B, HIGH); 
}

void leftspin(){

  PWM_RIGHT=100;
  PWM_LEFT=100;
  Serial.println( "LEFTSPIN " );
  analogWrite(EN_RMOT, PWM_RIGHT);
  digitalWrite(RMOT_A, LOW); 
  digitalWrite(RMOT_B, HIGH); 

  analogWrite(EN_LMOT, PWM_RIGHT);
  digitalWrite(LMOT_A, HIGH); 
  digitalWrite(LMOT_B, LOW); 
}

void datadump(){
    Serial.print( Righteye );
  Serial.print (" = right eye! ");
  Serial.print( Lefteye );
  Serial.print (" = left eye! ");
}
